//=============================================================================

/*:
 * @plugindesc サウンドテストをオプションメニューに入れる
 * 
 * @author LefTonbo
 *
 * @help
 * 特になし！
 */

//=============================================================================

//=============================================================================

(function() {

if (Imported.YEP_MusicMenu) {

//=============================================================================
// Scene_Options
//=============================================================================

var _Scene_Options_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
Scene_Options.prototype.createOptionsWindow = function() {
  _Scene_Options_createOptionsWindow.call(this);
  this._optionsWindow.setHandler('musicMenu', this.commandMusicMenu.bind(this));
};

Scene_Options.prototype.commandMusicMenu = function() {
  SceneManager.push(Scene_MusicMenu);
};

//=============================================================================
// Window_MenuCommand
//=============================================================================

var _Window_Options_addVolumeOptions= Window_Options.prototype.addVolumeOptions;
Window_Options.prototype.addVolumeOptions = function() {
  _Window_Options_addVolumeOptions.call(this);
  this.addMusicMenuCommand();
};

Window_Options.prototype.addMusicMenuCommand = function() {
  this.addCommand('サウンドテスト', 'musicMenu', true);
};

var _Window_Options_drawItem = Window_Options.prototype.drawItem;
Window_Options.prototype.drawItem = function(index) {
  if (this.commandSymbol(index) === 'musicMenu') {
    var rect = this.itemRectForText(index);
    var text = this.commandName(index);
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(text, rect.x, rect.y, rect.width, 'left');
  } else {
    _Window_Options_drawItem.call(this, index);
  }
};

var _Window_Options_processOk = Window_Options.prototype.processOk;
Window_Options.prototype.processOk = function() {
  if (this.commandSymbol(this.index()) === 'musicMenu') {
    Window_Command.prototype.processOk.call(this);
  } else {
    _Window_Options_processOk.call(this);
  }
};

//=============================================================================

}

})();

// EOF